<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	if(!isset($redirect)){
		$this->load->view('api/nav');
	}
	$this->load->helper('form');
	$user_info = $this->session->userdata('user_info');
	if(isset($user_info) && is_array($user_info)) { $user_data = TRUE; } else { $user_data = FALSE; }
?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div>
				<h1>Account Request</h1>
				
				<?PHP if(!$status || $status === 'No Requests' || $status === 'Denied') { ?>
				<div class="column">
					<?PHP 
						if($status === 'Denied') { 
							echo '<div id="denial_message">Your last account request was denied for the following reason:<p>';
							if(!empty($justification)) { echo $justification; }
							else { echo 'No justification was provided.'; }
							echo '</p>';
							echo '<p>Please correct any issues with your request before submitting a new one.</p>';
							echo '</div>';
						} 
					?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP 
					if(!isset($redirect)){
						echo form_open('/onboarding/account_request_save',array('id'=>'requestForm')); 
					}
					else{
						echo form_open('/authorize/check_registration',array('id'=>'requestForm'));
						echo '<input type="hidden" value="'. $redirect .'" name="redirect" id="redirect">';
					}
					?>
						<div class="form">
							<label for="first_name"><span class="red-text">*</span>First Name:</label> <input type="text" name="first_name" id="first_name" <?PHP if(isset($first_name)) { echo 'value="'.$first_name.'"'; } else if($user_data) { echo 'value="'.$user_info['first_name'].'"'; } ?>/>
							<label for="middle_name">Middle Name:</label> <input type="text" name="middle_name" id="middle_name" <?PHP if(isset($middle_name)) { echo 'value="'.$middle_name.'"'; } else if($user_data) { echo 'value="'.$user_info['middle_name'].'"'; }?>/>
							<label for="last_name"><span class="red-text">*</span>Last Name:</label> <input type="text" name="last_name" id="last_name" <?PHP if(isset($last_name)) { echo 'value="'.$last_name.'"'; } else if($user_data) { echo 'value="'.$user_info['last_name'].'"'; }?>/>
							<label for="ext_mail"><span class="red-text">*</span>Email Address:</label> <input type="text" name="ext_mail" id="ext_mail" <?PHP if(isset($ext_mail)) { echo 'value="'.$ext_mail.'"'; }else if($user_data) { echo 'value="'.$user_info['email'].'"'; }?>/>
							<label for="account_title">Title:</label> <input type="text" name="account_title" id="account_title" <?PHP if(isset($account_title)) { echo 'value="'.$account_title.'"'; }?>/>
							<label for="department">Department:</label> <input type="text" name="department" id="department" <?PHP if(isset($department)) { echo 'value="'.$department.'"'; }?>/>
							<label style="display:none;" for="organization">Organization:</label> <input style="display:none;" type="text" name="organization" id="organization" <?PHP if(isset($organization)) { echo 'value="'.$organization.'"'; }?>/>
							<label for="telephone">Telephone:</label> <input type="text" name="telephone" id="telephone" <?PHP if(isset($telephone)) { echo 'value="'.$telephone.'"'; }?>/>
							<label for="mobile">Mobile Phone:</label> <input type="text" name="mobile" id="mobile" <?PHP if(isset($mobile)) { echo 'value="'.$mobile.'"'; }?>/>
							<label style="display:none;" for="location">Location:</label> <input style="display:none;" type="text" name="location" id="location" <?PHP if(isset($location)) { echo 'value="'.$location.'"'; }?>/>
							<label for="facility"><span class="red-text">*</span>Facility:</label>
							<select id="facility_select" name="facility_select" data-placeholder="Choose a Facility" tabindex="">
           	 					<option value=""></option>
           	 					<option value="">&nbsp;</option>
           						<?php foreach($facilities as $fac) {
           							$option = '<option value=' . $fac->id;
           							if(isset($facility_select) && $fac->id == $facility_select) {
										$option .= ' selected';
									}
									$option .= '>' . $fac->name . '</option>';
           							echo $option;
           						}?>
            				</select>
							<?PHP if(isset($redirect)){  ?>
							<p class="extraPadding"><br/>
							Please deselect any item you don't want the <?php if(isset($app_name[0]->name)){echo $app_name[0]->name;} ?> application to be able to perform on your behalf:
							
							 
							<table class="display">
								<tr class="report_row">
									<th width="2%" style="color:#FFFFFF;"><input class="ttHover" id="select_all" name="select_all" title="Select All" type="checkbox"  checked  onclick="javascript:toggleSelectAll(this);"/></th>
									<th width="20%" style="color:#FFFFFF;">Service</th>
									<th width="77%" style="color:#FFFFFF;" class="displaylast">Description</th>
								</tr>
								<tr class="report_row white_bk">
									<td>
										<input type="checkbox" id="ws9" name="ws9" checked  onclick="javascript:toggleSelectAll(this);"/>
									</td>
									<td>
										<label for="wb3" style="width: 100px;">&nbsp;&nbsp;manage</label>
										<p class="hidden_context">Help Text for Direct API Permission: Please determine the permission to Direct API of the application above.</p> 
									</td>
									<td>
										Allows application to retrieve your messages									</td>
								</tr>
															<tr class="report_row white_bk" >
									<td>
										<input type="checkbox" id="ws8" name="ws8" checked onclick="javascript:toggleSelectAll(this);"/>
									</td>
									<td>
										<label for="wb2" style="width: 100px;">&nbsp;&nbsp;retrieve</label>
										<p class="hidden_context">Help Text for Direct API Permission: Please determine the permission to Direct API of the application above.</p> 
									</td>
									<td>
										Allows application to manage messages and folders									</td>
								</tr>
															<tr class="report_row white_bk">
									<td>
										<input type="checkbox" id="ws7" name="ws7" checked onclick="javascript:toggleSelectAll(this);"/>
									</td>
									<td>
										<label for="wb1" style="width: 100px;">&nbsp;&nbsp;send</label>
										<p class="hidden_context">Help Text for Direct API Permission: Please determine the permission to Direct API of the application above.</p> 
									</td>
									<td>
										Allows application to send a direct message on your behalf									</td>
								</tr>
														</table>
							

							<?PHP } ?>
							<p class="red-text">
								* = Required Field
							</p>
						</div>
						<div class="text-right"><input class="blue-button" type="submit" value="Submit Registration"/></div>
					<?PHP echo form_close(); ?>
				<?PHP } else if($status === 'Pending') { ?>
					<p>
						Account request has been submitted and is pending review by an administrator. 
						If you have provided an external email address, an email notification will be sent to it when the request status changes.
					</p>
				<?PHP } else { ?>
					<p>
						Your account is currently disabled, contact an administrator to request access.
					</p>
				<?PHP }?>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

<script type="text/javascript">
  $('#facility_select').chosen();
</script>
<script type="text/javascript">
$().ready(function() {
	toggleSelectAll(null);
});

function toggleSelectAll(checkbox) {
	var checkboxes = jQuery(':input:checkbox');

	if(checkbox == null || checkbox.id != 'select_all') {
		var allChecked = true;
		for(var i = 0; i < checkboxes.length; i++) {
			if(!checkboxes[i].checked && checkboxes[i].id != 'select_all') {
				allChecked = false;
			}
		}
		
		if(allChecked) {
			$("#select_all").attr('checked', true);
		}
		else {
			$("#select_all").attr('checked', false);
		}
	}
	else if(checkbox.id == 'select_all') {
		if(checkbox.checked) {
			for(var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].checked = true;
			}
		}
		else {
			for(var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].checked = false;
			}
		}
	}
}
</script>
